<?php

namespace Modules\Counseling\app\Http\Controllers\Admin;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Counseling\app\Models\CounselingType;
use Modules\Counseling\app\Http\Requests\CounselingTypeRequest;


class CounselingTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $types= CounselingType::when(Request()->tran_id != null,function ($query){
            $query->where('tran_id',Request()->tran_id);
        })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })->latest()->paginate(15);
        return view('counseling::Dashboard.Frest.counseling-type.index' , compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $trans = CounselingType::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();

        return view('counseling::Dashboard.Frest.counseling-type.create',compact('trans'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CounselingTypeRequest $request)
    {
        CounselingType::create([
            'title'=> $request->title ,
            'status' => $request->status,
            'tran_id' => $request->tran_id,
            'lang' =>$request->lang
        ]);

        session::flash('success', 'با موفقیت انجام شد');
        return  redirect()->route('admin.counselings-types.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('counseling::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $counselingType = CounselingType::find($id);
        if($counselingType->tran_id != null){
            $tran = CounselingType::find($counselingType->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $counselingType->translates->pluck('lang')->toArray();
        }

        return view('counseling::Dashboard.Frest.counseling-type.edit' , compact('counselingType','trans'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(CounselingTypeRequest $request, $id)
    {
        $counselingType = CounselingType::find($id);
        $counselingType->update([
            'title'=> $request->title ,
            'status' => $request->status,
            'lang' => $request->lang,
        ]);
        session::flash('success', 'با موفقیت انجام شد');
        return  redirect()->route('admin.counselings-types.index');

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $counselingType = CounselingType::find($id);
        $counselingType->delete();
        session::flash('success', 'با موفقیت انجام شد');
        return redirect()->back();
    }
}
