<?php

namespace Modules\Counseling\app\Http\Controllers\Admin;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Counseling\app\Models\CounselingType;
use Modules\Counseling\app\Models\CounselingWay;
use Modules\Counseling\app\Http\Requests\CounselinWayRequest;
use Modules\News\app\Models\Type;


class CounselingWayController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(CounselingType $type)
    {


        $ways = CounselingWay::when(Request()->tran_id != null,function ($query){
            $query->where('tran_id',Request()->tran_id);
        })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })->where('typeId', $type->id)->paginate(15);

        return view('counseling::Dashboard.Frest.counseling-way.index', compact('ways', 'type'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create($type)
    {
        $trans = CounselingWay::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();

        return view('counseling::Dashboard.Frest.counseling-way.create', compact('type','trans'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CounselinWayRequest $request, CounselingType $type)
    {
        $type->ways()->create([
            'title'=> $request->title ,
            'status' => $request->status,
            'tran_id' => $request->tran_id,
            'typeId' => $type->id,
            'lang' =>$request->lang,
            'value' => $request->value
        ]);
        Session::flash('success', 'با موفقیت انجام شد');
        return redirect()->route('admin.ways.index', compact('type'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {

        return view('counseling::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $way = CounselingWay::find($id);
        if($way->tran_id != null){
            $tran = CounselingWay::find($way->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $way->translates->pluck('lang')->toArray();
        }

        return view('counseling::Dashboard.Frest.counseling-way.edit', compact('way','trans'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(CounselinWayRequest $request, $id)
    {
        $way = CounselingWay::find($id);
        $way->update([
            'title'=> $request->title ,
            'status' => $request->status,
            'lang' => $request->lang,
            'value' => $request->value,
        ]);
        $type = $way->type;
        Session::flash('success', 'با موفقیت انجام شد');
        return redirect()->route('admin.ways.index', compact('type'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $way = CounselingWay::find($id);
        $way->delete();

        Session::flash('success', 'با موفقیت انجام شد');
        return redirect()->back();
    }
}
