<?php

namespace Modules\Counseling\app\Http\Controllers\Admin;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Counseling\app\Models\CounselingMonth;
use Modules\Counseling\app\Models\CounselingYear;
use Modules\Counseling\app\Http\Requests\CounselingYearRequest;

class CounselingYearController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $years = CounselingYear::latest()->paginate(15);
        return view('counseling::Dashboard.Frest.counseling-year.index' , compact('years'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('counseling::Dashboard.Frest.counseling-year.create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CounselingYearRequest $request)
    {
        $year = CounselingYear::create($request->validated());

        for($i=1;$i<=12;$i++){
            CounselingMonth::create([
                'month' => $i,
                'yearId' => $year->id,
                'status' => 1
            ]);
        }
        session::flash('success','با موفقیت انجام شد');
        return  redirect()->route('admin.counselings-years.index');

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('counseling::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $counseling_Year = CounselingYear::find($id);

        return view('counseling::Dashboard.Frest.counseling-year.edit' , compact('counseling_Year'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(CounselingYearRequest $request, $id)
    {

        $counselingYear = CounselingYear::find($id);
        $counselingYear->update($request->validated());
        session::flash('success','با موفقیت انجام شد');

        return  redirect()->route('admin.counselings-years.index');

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $counselingYear = CounselingYear::find($id);
        $counselingYear->delete();
        session::flash('success','با موفقیت انجام شد');
        return  redirect()->back();
    }
}
