<?php

namespace Modules\Counseling\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CounselingRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'consultantId' => 'required',
            'typeId'=> 'required',
            'wayId' => 'required',
            'price' => 'required',
            'state' => 'required',
            'hours' => 'required',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function prepareForValidation()
    {
        $this->merge([
           'price' => (int)$this->price,
           'state' => (int)$this->state,

        ]);

    }
}
