<?php

namespace Modules\Counseling\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CounselingTypeRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'=> 'required' ,
            'status' => 'required',
            'tran_id' => 'nullable',
            'lang' => 'required',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function prepareForValidation()
    {
        $this->merge([
           'status' => (int)$this->status
        ]);
    }
}
