<?php

namespace Modules\Counseling\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CounselingYearRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'year' => 'required',
            'status' => 'required',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => (int)$this->status
        ]);
    }
}
