<?php

namespace Modules\Counseling\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Consultant extends Model
{
    use HasFactory;

    protected  $table = 'Consultants';

    protected $fillable = [
        'name' ,
        'lastname',
        'mobile',
        'resume',
        'body',
        'image',
        'cat_id',
        'status'
    ];


    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query->where('status',1);
    }

    public function counselings()
    {
        return $this->hasMany(Counseling::class , 'consultantId');
    }

}
