<?php

namespace Modules\Counseling\app\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Counseling extends Model
{
    use HasFactory;

    protected $table = 'counselings';
        protected $casts = [
            'start_date' => 'array',
            'end_date' => 'array',
        ];

    protected $fillable = [
        'yearId',
        'monthId',
        'consultantId',
        'userId',
        'typeId',
        'wayId',
        'start_date',
        'end_date',
        'price',
        'state',
        'status',
    ];

    public static $TIME=[
            'یک' => 1 ,
            'دو' => 2 ,
            'سه' => 3 ,
            'چهار' => 4 ,
    ];


    public function year()
    {
        return $this->belongsTo(CounselingYear::class , 'yearId');
    }

    public function type()
    {
        return $this->belongsTo(CounselingType::class, 'typeId');
    }

    public function way()
    {
        return $this->belongsTo(CounselingWay::class, 'wayId');
    }

    public function month()
    {
        return $this->belongsTo(CounselingMonth::class, 'monthId');
    }

    public function consultant()
    {
        return $this->belongsTo(Consultant::class, 'consultantId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'userId');
    }


}
