<?php

namespace Modules\Counseling\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CounselingMonth extends Model
{
    use HasFactory;

    protected $table = 'counselings_months';
    protected $fillable = [
        'month',
        'yearId',
        'status'
    ];


    public function year()
    {
        return $this->belongsTo(CounselingYear::class, 'yearId');
    }

    public function counselings()
    {
        return $this->hasMany(Counseling::class, 'monthId');
    }
}
