<?php

namespace Modules\Counseling\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Language\app\Models\Language;
use Modules\Site\app\Models\Site;

class CounselingWay extends Model
{
    use HasFactory;

    protected $table = 'counselings_ways';

    protected $fillable = [
        'title' ,
        'value' ,
        'typeId',
        'tran_id',
        'lang'
    ];

    public function translates(){
        return $this->hasMany(Site::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }
    public function consultants()
    {
        return $this->hasMany(Counseling::class, 'wayId');
    }
    public function type()
    {
        return $this->belongsTo(CounselingType::class, 'typeId');
    }


}
