<?php

namespace Modules\Counseling\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CounselingYear extends Model
{
    use HasFactory;

    protected $table = 'counselings_years';
    protected $fillable = [
        'year',
        'status'
    ];

    public function consultants()
    {
        return $this->hasMany(Counseling::class, 'yearId');
    }
    public function months()
    {
        return $this->hasMany(CounselingMonth::class, 'yearId');
    }
}
