<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('counselings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('yearId')->constrained('counselings_years')->onDelete('cascade');
            $table->foreignId('monthId')->constrained('counselings_months')->onDelete('cascade');
            $table->foreignId('consultantId')->constrained('Consultants')->onDelete('cascade');
            $table->foreignId('userId')->nullable()->constrained('users')->onDelete('cascade');
            $table->foreignId('typeId')->constrained('counselings_types')->onDelete('cascade');
            $table->foreignId('wayId')->constrained('counselings_ways')->onDelete('cascade');
            $table->json('start_date')->nullable();
            $table->json('end_date')->nullable();
            $table->bigInteger('price');
            $table->tinyInteger('state')->default(0);
            $table->enum('status' , ['reserved' , 'paid' , 'canceled' , 'open' ])->default('open');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('Counselings_time');
    }
};
