@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font"> ویرایش </h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                    aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{ route('admin.consultants.update', $consultant) }}" method="post">
                            @csrf
                            @method('put')


                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-4">
                                            <label class="form-label" for="title">تصویر مشاور</label>
                                            <div class="input-group">
                                                <input value="{{  old('image',$consultant->image) }} type="text" id="image-2" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image-2" />
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image-2">آپلود</button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">نام </label>
                                            <input type="text" id="year" name="name" class="form-control"
                                                   placeholder="نام" value="{{  old('name',$consultant->name) }}">
                                            @if ($errors->has('name'))
                                                <div data-field="title" class="text-danger">
                                                    {{ $errors->first('name') }}</div>
                                            @endif
                                        </div>
                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">نام خانوادگی</label>
                                            <input type="text" id="year" name="lastname" class="form-control"
                                                   placeholder="نام خانوادگی"
                                                   value="{{ old('lastname',$consultant->lastname) }}">
                                            @if ($errors->has('lastname'))
                                                <div data-field="title" class="text-danger">
                                                    {{ $errors->first('lastname') }}</div>
                                            @endif
                                        </div>
                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">شماره تماس</label>
                                            <input type="text" id="year" name="mobile" class="form-control"
                                                   placeholder="شماره تماس"
                                                   value="{{ old('mobile',$consultant->mobile) }}">
                                            @if ($errors->has('mobile'))
                                                <div data-field="title" class="text-danger">
                                                    {{ $errors->first('mobile') }}</div>
                                            @endif
                                        </div>
                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">رزومه</label>
                                            <input type="text" id="year" name="resume" class="form-control"
                                                   placeholder="رزومه"
                                                   value="{{  old('resume',$consultant->resume) }}">
                                            @if ($errors->has('resume'))
                                                <div data-field="title" class="text-danger">
                                                    {{ $errors->first('resume') }}</div>
                                            @endif
                                        </div>
                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">متن کامل</label>
                                            <textarea type="text" id="year" name="body" class="form-control"
                                                      placeholder="متن کامل"
                                                      >{{  old('body',$consultant->body) }}</textarea>
                                            @if ($errors->has('body'))
                                                <div data-field="title" class="text-danger">
                                                    {{ $errors->first('body') }}</div>
                                            @endif
                                        </div>

                                    </div>

                                </div>


                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.consultants.index') }}"
                                   class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
