@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
  راه های ارتباطی
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">

                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <form action="#" method="get">

            @if(Request()->tran_id == null)
                <a class="btn btn-primary me-1" href="{{ route('admin.counselings-types.create') }}" role="button" aria-expanded="false" >جدید</a>
            @endif
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("نوع های مشاوره")}}</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>نام</th>
                            <th>وضعیت</th>
                            <th>زبان</th>
                            <th>راه های ارتباط</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($types as $type)
                            <tr>
                                <th>
                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$type->id}}" type="checkbox">
                                        <label for="bulk-ids"></label>
                                    </div>
                                </th>

                                <td>
                                    <a href="{{route('admin.counselings-types.index',['tran_id' => $type->id])}}">
                                        <span class="btn btn-info text-white" > {{$type->title }}</span>
                                    </a></br>
                                </td>


                                @if($type->status == 1)
                                    <td><span class="badge bg-label-success me-1">فعال</span></td>
                                @endif
                                @if($type->status == 0)
                                    <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                                @endif

                                <td>
                                    {{$type->language->title}}
                                </td>

                                <td><a class="btn btn-warning" href="{{route('admin.ways.index' , $type)}}">راه ها</a></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">

                                            <a class="dropdown-item" href="{{ route('admin.counselings-types.edit' ,$type->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>
                                            @if($type->tran_id == null && count($languages) > count($type->translates) + 1)
                                                <a class="dropdown-item" href="{{ route('admin.counselings-types.create' ,['tran_id' => $type->id]) }}"><i class="bx bx-edit-alt me-1"></i>ترجمه</a>
                                            @endif

                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$type->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$type->id}}" action="{{ route('admin.counselings-types.destroy', $type->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $types->render() }}
                </div>
            </div>



    </div>
@endsection
