@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')

@endsection

@section('script')

@endsection

@section('content')

    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                    aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{route('admin.counselings-ways.store' , $type)}}" method="post">
                            {{ csrf_field() }}
                            <input type="text" name="tran_id" value="{{Request()->tran_id}}"  style="opacity: 0;">

                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان </label>
                                            <input type="text" id="title" name="title" class="form-control"
                                                   placeholder="عنوان " value="{{old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title"
                                                     class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="title">مقدار </label>
                                            <input type="text" id="title" name="value" class="form-control"
                                                   placeholder="مقدار " value="{{old('value')}}">
                                            @if($errors->has('value'))
                                                <div data-field="title"
                                                     class="text-danger">{{ $errors->first('value') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-4">
                                            <span>*</span>
                                            <label class="form-label" for="state">زبان</label>
                                            <div class="position-relative">
                                                <select required id="lang" name="lang" class="form-select" >
                                                    @foreach($languages as $language)

                                                        @if(!in_array($language->name,$trans) || Request()->tran_id == null)
                                                            <option value="{{$language->name}}" {{$language->name == old('lang') ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>



                                    </div>

                                </div>


                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.ways.index' ,$type) }}" type="reset"
                                   class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

@endsection
