@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
     سال های مشاوره
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.counselings-years.index')}}"
                                    method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <form action="#" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.counselings-years.create') }}" role="button"
                    aria-expanded="false">جدید</a>
                <a href="{{ route('admin.counselings-types.index') }}" class="btn btn-danger me-1">نوع ارتباط</a>
                <a href="{{ route('admin.consultants.index') }}" class="btn btn-warning me-1"  >مشاورها</a>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
            <h5 class="card-header">  سال های مشاوره</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>وضعیت</th>
                            <th>ماه ها</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($years as $year)
                            <tr>
                                <th>
                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$year->id}}" type="checkbox">
                                        <label for="bulk-ids"></label>
                                    </div>
                                </th>
                                <td><span class="bg-primary rounded badge-primary text-white py-2 px-4">{{$year->year}}</span> </td>
                                @if($year->status == 1)
                                    <td><span class="badge bg-label-success me-1">فعال</span></td>
                                @endif
                                @if($year->status == 0)
                                    <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                                @endif

                                <td><a class="btn btn-warning" href="{{ route('admin.counselings-months.index' , $year) }}">ماه ها</a></td>

                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">

                                            <a class="dropdown-item" href="{{ route('admin.counselings-years.edit' ,$year->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$year->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$year->id}}" action="{{ route('admin.counselings-years.destroy', $year->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $years->render() }}
                </div>
            </div>



    </div>
@endsection
