@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    ویرایش مشاوره
@endsection

@section('style')

@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.counselings.index' , $counseling->month)}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </section>
    </div>


    <div class="card">
        <form action="#" method="get">
            <p class="demo-inline-spacing">
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>

        <div class="tab-content">
            <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                <form action="{{route('admin.counselings.update' , $counseling)}}" method="post">
                    {{ csrf_field() }}
                    @method('put')

                    <div class="row g-3">

                        <div class="col-md-12">

                            <div class="row">

                                <div class="col-md-4">
                                    <span>*</span>
                                    <label class="form-label" for="state">مشاور</label>
                                    <div class="position-relative">
                                        <select id="state" name="consultantId" class="form-select">
                                            <option value="">انتخاب</option>
                                            @foreach($consultants as $consultant)

                                                <option  {{ $counseling->consultantId == $consultant->id ? 'selected' : '' }}
                                                    value="{{ $consultant->id }}">{{ $consultant->name.$consultant->lastname }}
                                                </option>

                                            @endforeach

                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <span>*</span>
                                    <label class="form-label" for="state">نوع مشاوره</label>
                                    <div class="position-relative">
                                        <select id="state" name="typeId" class="form-select">
                                            <option value="">انتخاب</option>
                                            @foreach($types as $type)
                                                <option  {{ $counseling->typeId == $type->id ? 'selected' : '' }}
                                                 value="{{ $type->id }}">{{ $type->title }}
                                                </option>

                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <span>*</span>
                                    <label class="form-label" for="state">راه مشاوره</label>
                                    <div class="position-relative">
                                        <select id="state" name="wayId" class="form-select">
                                            <option value="">انتخاب</option>
                                            @foreach($ways as $way)

                                                <option      {{ $counseling->wayId == $way->id ? 'selected' : '' }}
                                                 value="{{ $way->id }}">{{ $way->title }}
                                                </option>

                                            @endforeach

                                        </select>
                                    </div>
                                </div>


                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-4">
                                    <span>*</span>
                                    <label class="form-label" for="state">هزینه</label>
                                    <input type="text" id="title" name="price" class="form-control"
                                           placeholder="هزینه مشاوره" value="{{$counseling->price , old('price')}}">
                                </div>

                                <div class="col-md-4">
                                    <span>*</span>
                                    <label class="form-label" for="state">وضعیت</label>
                                    <div class="position-relative">
                                        <select id="state" name="state" class="form-select">
                                            <option value="">انتخاب</option>
                                            <option value="1" {{'1' == $counseling->state ? 'selected' : ''}}>فعال
                                            </option>
                                            <option value="0" {{'0' == $counseling->state ? 'selected' : ''}}>غیر
                                                فعال
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <span>*</span>
                                    <label class="form-label" for="state">زمان مشاوره</label>
                                    <div class="position-relative">
                                        <select id="state" required name="hours" class="form-select">
                                            <option value="">انتخاب</option>

                                            @foreach(\Modules\Counseling\app\Models\Counseling::$TIME as $key => $value)

                                                <option value="{{ $value }}" {{'1' == old('hours') ? 'selected' : ''}}>{{$key}} ساعت
                                                </option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>

                            </div>
                            <hr>

                            <div class="row">
                                <div class="col-2">
                                    <label for="flatpickr-datetime" class="form-label">تاریخ</label>
                                    <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="date" id="publish_up" value="{{verta($counseling->start_date)->format('Y-m-d H:i:s')}}" />
                                </div>
                            </div>



                        </div>


                    </div>
                    <div class="pt-4">
                        <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                        <a href="{{ route('admin.counselings.index' , $counseling->month) }}" type="reset"
                           class="btn btn-label-secondary">انصراف</a>
                    </div>
                </form>
            </div>

        </div>


    </div>
@endsection
