@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    مشاوره ها
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.counselings.index' , $month)}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <form action="#" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.counselings.create' , $month) }}" role="button"
                   aria-expanded="false">مشاوره جدید</a>

            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>

                    <th>سال</th>
                    <th>ماه</th>
                    <th>نوع</th>
                    <th>راه ارتباط</th>
                    <th>مشاور</th>
                    <th>مشاوره شونده</th>
                    <th>تاریخ شروع</th>
                    <th>تاریخ پایان</th>
                    <th> هزینه</th>
                    <th> وضعیت</th>
                    <th> تنظیمات</th>




                </tr>
                </thead>
                <tbody>

                @foreach ($counselings as $counseling)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$counseling->id}}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td> {{$counseling->year->year}}</td>
                        <td> {{$counseling->month->month}}</td>
                        <td> {{$counseling->type->title}}</td>
                        <td> {{$counseling->way->title}}</td>
                        <td> {{$counseling->consultant->name .$counseling->consultant->lastname}}</td>
                        <td> {{$counseling->user == null ? 'تایم آزاد' : $counseling->user->name}}</td>
                        <td>
                            {{Verta($counseling->start_date)->format('Y-m-d H:i:s')}}
                        </td>
                        <td>
                            {{Verta($counseling->end_date)->format('Y-m-d H:i:s')}}
                        </td>
                        <td> {{ number_format($counseling->price)}}</td>
                        @if($counseling->state == 1)
                            <td><span class="badge bg-label-success me-1">فعال</span></td>
                        @endif
                        @if($counseling->state == 0)
                            <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                        @endif

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">

                                    <a class="dropdown-item" href="{{ route('admin.counselings.edit' ,$counseling->id) }}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>


                                    <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$counseling->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{$counseling->id}}" action="{{ route('admin.counselings.destroy', $counseling->id) }}" method="POST" style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{ $counselings->render() }}
            </div>
        </div>



    </div>
@endsection
