<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Modules\Counseling\app\Models\CounselingWay;
use Modules\Counseling\app\Http\Controllers\Admin\CounselingController;
use Modules\Counseling\app\Http\Controllers\Admin\CounselingMonthController;
use Modules\Counseling\app\Http\Controllers\Admin\CounselingWayController;

Route::as('admin.')->prefix('Admin')->namespace('Admin')->middleware('auth:admin', 'check_role_admin')->group(function () {


    Route::Resource('counselings-years', 'CounselingYearController');

    Route::Resource('consultants', 'ConsultantController');
    Route::Resource('counselings-types', 'CounselingTypeController');


    Route::get('counselings/index/{month}', [CounselingController::class, 'index'])->name('counselings.index');
    Route::get('counselings/create/{month}', [CounselingController::class, 'create'])->name('counselings.create');
    Route::post('counselings/store/{month}', [CounselingController::class, 'store'])->name('counselings.store');
    Route::get('counselings/edit/{counseling}', [CounselingController::class, 'edit'])->name('counselings.edit');
    Route::put('counselings/update/{counseling}', [CounselingController::class, 'update'])->name('counselings.update');
    Route::delete('counselings/destroy/{counseling}', [CounselingController::class, 'destroy'])->name('counselings.destroy');

        Route::get('counselings-ways/index/{type}',[CounselingWayController::class, 'index'])->name('ways.index');

    Route::get('counselings-ways/create/{type}', [CounselingWayController::class, 'create'])->name('counselings-ways.create');
    Route::post('counselings-ways/store/{type}', [CounselingWayController::class, 'store'])->name('counselings-ways.store');
    Route::get('counselings-ways/edit/{way}', [CounselingWayController::class, 'edit'])->name('counselings-ways.edit');
    Route::put('counselings-ways/update/{way}', [CounselingWayController::class, 'update'])->name('counselings-ways.update');
    Route::delete('counselings-ways/destroy/{way}', [CounselingWayController::class, 'destroy'])->name('counselings-ways.destroy');


    Route::get('counselings-months/{year}/index', [CounselingMonthController::class, 'index'])->name('counselings-months.index');

});
