<?php

namespace Modules\Course\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Course\app\Models\Course;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $courses = Course::all();
        return response()->json($courses);
    }

    // نمایش اطلاعات یک دوره خاص
    public function show($id)
    {
        $course = Course::with(['prerequisites', 'followUps'])->findOrFail($id);
        return response()->json($course);
    }

    // ایجاد دوره جدید
    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'slug' => 'required|string|unique:courses',
            'level' => 'required|string|in:beginner,intermediate,advanced',
            'duration' => 'required|integer',
        ]);

        $course = Course::create($validated);
        return response()->json($course, 201);
    }

    // آپدیت دوره
    public function update(Request $request, $id)
    {
        $course = Course::findOrFail($id);

        $validated = $request->validate([
            'title' => 'string|max:255',
            'description' => 'string',
            'slug' => 'string|unique:courses,slug,' . $id,
            'level' => 'string|in:beginner,intermediate,advanced',
            'duration' => 'integer',
        ]);

        $course->update($validated);
        return response()->json($course);
    }

    // حذف دوره
    public function destroy($id)
    {
        $course = Course::findOrFail($id);
        $course->delete();
        return response()->json(null, 204);
    }
}
