<?php

namespace Modules\Course\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Course\Database\factories\CourseFactory;

class Course extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'title', 'description', 'slug', 'image', 'level', 'duration', 'is_active'
    ];

    // ارتباط با پیش‌نیازها
    public function prerequisites()
    {
        return $this->belongsToMany(Course::class, 'course_prerequisite', 'course_id', 'prerequisite_id');
    }

    // ارتباط با دوره‌های بعدی
    public function followUps()
    {
        return $this->belongsToMany(Course::class, 'course_follow_up', 'course_id', 'follow_up_id');
    }
    public function categories()
    {
        return $this->belongsToMany(Category::class, 'course_category');
    }
}
