<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('slug')->unique();
            $table->string('image')->nullable();
            $table->enum('level', ['beginner', 'intermediate', 'advanced']); // سطح دوره
            $table->integer('duration'); // مدت زمان دوره به ساعت
            $table->boolean('is_active')->default(true); // وضعیت فعال بودن دوره
            $table->timestamps();
        });

        // ایجاد جدول پیوندی برای پیش‌نیازها
        Schema::create('course_prerequisite', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('course_id');
            $table->unsignedBigInteger('prerequisite_id');
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->foreign('prerequisite_id')->references('id')->on('courses')->onDelete('cascade');
        });

        // ایجاد جدول پیوندی برای دوره‌های بعدی
        Schema::create('course_follow_up', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('course_id');
            $table->unsignedBigInteger('follow_up_id');
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->foreign('follow_up_id')->references('id')->on('courses')->onDelete('cascade');
        });
        Schema::create('videos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('course_id')->nullable(); // برای ویدیوهای اصلی
            $table->unsignedBigInteger('parent_id')->nullable(); // برای مشخص کردن قسمت‌های ویدیو
            $table->string('title'); // عنوان ویدیو یا قسمت
            $table->string('video_path'); // مسیر فایل ویدیو
            $table->timestamps();

            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->foreign('parent_id')->references('id')->on('videos')->onDelete('cascade');
        });
        Schema::create('attachments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('video_id'); // ارتباط فایل ضمیمه با ویدیو یا قسمت
            $table->string('attachment_name'); // نام فایل ضمیمه
            $table->string('attachment_path'); // مسیر فایل ضمیمه
            $table->timestamps();

            $table->foreign('video_id')->references('id')->on('videos')->onDelete('cascade');
        });

        Schema::create('course_category', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('course_id');
            $table->unsignedBigInteger('category_id');
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->timestamps();
        });

    }


    public function down()
    {
        Schema::dropIfExists('course_follow_up');
        Schema::dropIfExists('course_prerequisite');
        Schema::dropIfExists('courses');
        Schema::dropIfExists('course_files');
        Schema::dropIfExists('course_category');


    }

};
