@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />

        <style>
            option[data-lang="en"] {
                display: none;
            }
        </style>
    @endsection

    @section('script')



        <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

        <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

        <script>
            var options = {
                filebrowserImageBrowseUrl: '/file-manager/ckeditor',
            };
            CKEDITOR.replace('body' ,options);
            $('#submit').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) {
                    e.preventDefault();
                    return false;
                }
            });




        </script>

        <script>
            const tag1 = document.querySelector("#tag");
            const tag = new Tagify(tag1, {
                whitelist: [{!!  \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],
                dropdown: {
                    classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted
                    enabled: 0,             // <- show suggestions on focus
                    closeOnSelect: false    // <- do not hide the suggestions dropdown once an item has been selected
                }
            });
        </script>

    @endsection

@section('content')


        @include('core::components.file_set_to_editor')
    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>

                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#publish" role="tab" aria-selected="true">
                                انتشار
                            </button>
                        </li>

                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#gallery" role="tab"
                                aria-selected="true">
                                گالری
                            </button>
                        </li>
                        @foreach($field_groups->where('type','news') as $group)

                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#{{$group->name}}" role="tab" aria-selected="true">
                                    {{$group->title}}
                                </button>
                            </li>


                        @endforeach

                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formAutoSave" action="{{route('admin.news.store')}}" method="post">
                        {{ csrf_field() }}

                        <input type="text" name="tran_id" value="{{Request()->tran_id}}"  style="opacity: 0;">

                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-12">

                                    <div class="row">

                                        <div class="col-md-12">
                                            <div class="col-md-6">
                                                <label class="form-label" for="title">روتیتر</label>
                                                <input type="text" id="title_little"  name="title_little" class="form-control" placeholder="روتیتر" value="{{old('title_little')}}">
                                                @if($errors->has('title'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                                @endif
                                            </div>
                                        </div>



                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">اسلاگ</label>
                                            <input type="text" id="slug" name="slug" class="form-control"
                                                   placeholder="اسلاگ" value="">
                                            @if ($errors->has('slug'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('slug') }}
                                                </div>
                                            @endif
                                        </div>


                                        <div class="col-md-6">
                                            <label class="form-label" for="title">تصویر</label>
                                            <div class="input-group">
                                                <input type="text" id="image1" class="form-control" name="image1"
                                                       aria-label="Image" aria-describedby="button-image">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select id="state" name="state" class="form-select" >
                                                    <option value="1" {{'1' == old('state') ? 'selected' : ''}}>فعال</option>
                                                    <option value="0" {{'0' == old('state') ? 'selected' : ''}}>غیر فعال</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <span>*</span>
                                            <label class="form-label" for="state">ویژه</label>
                                            <div class="position-relative">
                                                <select id="special" name="special" class="form-select" >
                                                    <option value="1" {{'1' == old('special') ? 'selected' : ''}}>ویژه</option>
                                                    <option value="0" {{'0' == old('special') ? 'selected' : ''}}>غیر ویژه</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">لید خبر</label>
                                            <textarea type="text" id="lead"  name="lead" class="form-control" >{{old('lead')}}</textarea>
                                            @if($errors->has('lead'))
                                                <div data-field="lead" class="text-danger">{{ $errors->first('lead') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-12">
                                             <label class="form-label" for="desc">متن خبر</label>
                                             <textarea  type="text" id="body"  name="body" class="form-control" ><a href="{{config('app.url')}}" target="_blank" dir="rtl" style="color: #0000ff;">{{config('app.text_editor')}}</a></textarea>
                                            @if($errors->has('body'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('body') }}</div>
                                            @endif


                                            <br>
                                            <button type="button"  data-bs-toggle="modal" data-bs-target="#create-file-editor" class="btn btn-warning me-1">درج ویدیو و صوت در ادیتور</button>

                                        </div>


                                    </div>

                                </div>





                            </div>


                          </div>
                        <div class="tab-pane fade " id="publish" role="tabpanel">


                            <div class="row g-3">


                                <div class="col-md-5">

                                    <div class="row">

                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="state">زبان</label>
                                            <div class="position-relative">
                                                <select id="lang" name="lang" class="form-select" >
                                                    @foreach($languages as $language)
                                                        @if(!in_array($language->name,$trans) || Request()->tran_id == null)
                                                            <option value="{{$language->name}}" {{$language->name == old('lang') ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">سرویس های نمایشی</label>
                                            <select id="selectpickerSelectDeselect" name="service_ids[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($services as $service)
                                                    <option value="{{$service->id}}" data-lang="en">{{$service->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی اصلی</label>
                                            <select id="selectpickerSelectDeselect" name="cat_id" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true" required>
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category,'cat_id' => null,'model' => null])
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-12 mb-10 ">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی فرعی</label>
                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category,'cat_id' => null,'model' => null])
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">نوع خبر</label>
                                            <select id="selectpickerSelectDeselect"  name="type_id" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true">
                                                @foreach($types as $item)
                                                    <option value="{{$item->id}}" {{old('type_id') == $item->id ? 'selected' : ''}}>{{$item->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-12">
                                                <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت  شروع انتشار</label>
                                                <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_up" id="publish_up"  value="{{old('publish_up')}}" />
                                        </div>

                                        <div class="col-md-12">
                                            <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان انتشار</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_down" id="publish_down" value="{{old('publish_down')}}" />
                                        </div>

                                        <div class="col-md-12">
                                            <label for="flatpickr-datetime" class="form-label">فوری  و مهم </label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="instant" id="instant" value="{{old('instant')}}" />
                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-6">

                                    <div class="row">

                                        <div class="col-md-12">
                                            <label class="form-label" for="title">فایل</label>
                                            <div class="input-group">
                                                <input type="text" id="image-2" class="form-control" name="file"
                                                       aria-label="Image" aria-describedby="button-image-2">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image-2">آپلود</button>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">منبع خبر</label>
                                            <select id="selectpickerSelectDeselect"  name="source_id" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true">
                                                @foreach($sources as $item)
                                                    <option value="{{$item->id}}" {{old('source_id') == $item->id ? 'selected' : ''}}>{{$item->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label" for="title">لینک خبر</label>
                                            <input type="text" id="link_source"  name="link_source" class="form-control" placeholder="لینک خبر" value="{{old('link_source')}}">
                                            @if($errors->has('link_source'))
                                                <div data-field="link_source" class="text-danger">{{ $errors->first('link_source') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-12">
                                            <label for="tag" class="form-label">تگ</label>
                                            <input id="tag" class="form-control" name="tag" value="{{old('tag')}}" />
                                        </div>

                                        <div class="col-md-12">
                                            <label for="meta_tag" class="form-label">متا تگ</label>
                                            <input id="meta_tag" class="form-control" name="meta_tag" value="{{old('meta_tag')}}" />
                                        </div>

                                        <div  class="col-md-12">
                                            <label for="meta_desc" class="form-label">توضیحات متا</label>
                                            <textarea id="meta_desc" class="form-control" name="meta_desc">{{old('meta_desc')}}</textarea>
                                        </div>

                                    </div>

                                </div>





                            </div>


                        </div>
                        <div class="tab-pane fade " id="gallery" role="tabpanel">

                            <div class="row">
                                @for($i=0;$i<15;$i++)

                                    <div class="col-md-6">

                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label" for="title">فایل</label>
                                                <div class="input-group">
                                                    <input type="text" id="input-gallery-{{$i + 1}}" class="form-control" name="files[]"
                                                           aria-label="Image" aria-describedby="button-gallery-{{$i + 1}}">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-outline-secondary" type="button" id="button-gallery-{{$i + 1}}">آپلود</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label" for="title">توضیح</label>
                                                <div class="input-group">
                                                    <input type="text" id="notes" class="form-control" name="notes[]" aria-label="Image" >
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                @endfor
                            </div>

                        </div>
                        @foreach($field_groups->where('type','news') as $group)

                            <div class="tab-pane fade " id="{{$group->name}}" role="tabpanel">


                                <div class="row g-3">

                                    <div class="col-md-12">

                                        <div class="row">

                                            @foreach($group->fields as $field)



                                                @if($field->type == 'string')
                                                    <div class="col-md-6">
                                                        <label for="{{$field->name}}" class="form-label">{{$field->title}}</label>
                                                        <input type="text" class="form-control" name="fields[{{$field->name}}]" id="{{$field->name}}" value="{{isset($news) && $news->fields->where('field_id',$field->id)->first() != null ? $news->fields->where('field_id',$field->id)->first()->value->value : ''}}" />
                                                    </div>
                                                @endif


                                            @endforeach


                                        </div>

                                    </div>




                                </div>


                            </div>


                        @endforeach

                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.news.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>



    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
        integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>

    <script src="{{ asset('modules/core/js/title-to-slug.js') }}"></script>

    <script>
        function addFormElements(current) {
            let newForm = $(current).parents('.form-list').append($(current).parents('.form-row').clone())
            let eles = document.getElementsByClassName('new-image');
            var i = 0;
            for (let item of eles) {
                item.id = 'image' + i
                i++
            }
        }
    </script>
@endsection
