<?php

namespace Modules\Dashboard\app\Http\Controllers\Dashboard\Frest;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Modules\Comment\app\Models\Comment;
use Modules\Contact\app\Http\Controllers\ContactController;
use Modules\Contact\app\Models\Contact;
use Modules\Contact\app\Models\Cooperation;
use Modules\News\app\Models\News;
use Modules\Site\app\Models\Site;

class DashboardController extends Controller
{


    public function index()
    {


        $news = News::first();

        $date_now = Carbon::now();

        $visit_all = 0;


        $visit_day = 0;
        $visit_week = 0;
        $visit_month = 0;
        $visit_year = 0;


        $visit_news_day = 0;
        $visit_news_week = 0;
        $visit_news_month = 0;
        $visit_news_year = 0;

        $count_news = 0;
        $count_news_unpublish = 0;
        $count_comments = 0;
        $count_comments_unpublish = 0;
        $count_contacts = 0;
        $count_users = 0;


        $count_comments = Comment::whereState(0)->count();
        $count_cooperation = Cooperation::count();
        $count_order = Contact::where('read',0)->where('type','order')->count();

        $sum_contacts = $count_order + $count_cooperation + $count_order;


        $list_comments_unpublish = Comment::whereState(0)->latest()->take(5)->get();

        $latest_comments = Comment::latest()->take(10)->get();
        $latest_news = News::latest()->take(10)->get();



        $site = Site::whereState(1)->first();

        return view('dashboard::Dashboard.Frest.'.$site->type,compact('list_comments_unpublish',
            'count_cooperation','count_order','sum_contacts',
            'visit_news_day','visit_news_week','visit_news_month','visit_news_year',
            'visit_day','visit_week','visit_year','visit_month','visit_all','count_news',
            'count_news_unpublish','count_comments','count_comments_unpublish','count_contacts','count_users'));
    }





}
