<?php

namespace Modules\Faq\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Faq\app\Models\Faq;
use Modules\News\app\Http\Requests\Dashboard\Frest\Type\TypeStoreRequest;
use Modules\News\app\Http\Requests\Dashboard\Frest\Type\TypeUpdateRequest;


class FaqController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('question.access');
        $faqs_items = Faq::
        when(Request()->q != null,function ($query){
            return $query->where('title','LIKE','%'.Request()->q."%");
        })
            ->latest()->paginate(15);


        return view('faq::Dashboard.Frest.faq.index',compact('faqs_items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('question.create');
        return view('faq::Dashboard.Frest.faq.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TypeStoreRequest $request)
    {

        $this->authorize('question.create');
        Faq::create([
            'title' => $request->title,
            'state' => $request->state,
            'body' => $request->body,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.faq.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Faq $faq)
    {
        $this->authorize('question.edit');
        return view('faq::Dashboard.Frest.faq.edit',compact('faq'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(TypeUpdateRequest $request, $id)
    {

        $this->authorize('question.edit');
        $faq = Faq::find($id);



        $faq->title = $request->title;
        $faq->state = $request->state;
        $faq->body = $request->body;

        $faq->save();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.faq.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('question.delete');
        $type = Faq::find($id);

        $type->delete();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.faq.index');
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('question.delete');
            Faq::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('question.edit');
            Faq::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('question.edit');
            Faq::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
