<?php

namespace Modules\News\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Modules\News\app\Models\Source;
use Modules\News\Http\Requests\Dashboard\Frest\Source\SourceStoreRequest;
use Modules\News\Http\Requests\Dashboard\Frest\Source\SourceUpdateRequest;


class SourceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('source.access');

        $sources = Source::
        when(Request()->q != null,function ($query){
            return $query->where('title','LIKE','%'.Request()->q."%");
        })
            ->latest()->paginate(15);


        return view('news::Dashboard.Frest.source.index',compact('sources'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('source.create');
        return view('news::Dashboard.Frest.source.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SourceStoreRequest $request)
    {
        $this->authorize('source.create');

        Source::create([
            'title' => $request->title,
            'state' => $request->state,
            'url' => $request->url,
            'desc' => $request->desc,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.source.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Source $source)
    {
        $this->authorize('source.edit');
        return view('news::Dashboard.Frest.source.edit',compact('source'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(SourceUpdateRequest $request, $id)
    {
        $this->authorize('source.edit');

        $source = Source::find($id);



        $source->title = $request->title;
        $source->state = $request->state;
        $source->url = $request->url;
        $source->desc = $request->desc;

        $source->save();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.source.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $this->authorize('source.delete');
        $source = Source::find($id);

        $source->delete();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.source.index');
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
            $this->authorize('source.delete');

            Source::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('source.edit');
            Source::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('source.edit');
            Source::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}

