<?php

namespace Modules\News\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Modules\News\app\Models\Type;
use Modules\News\app\Http\Requests\Dashboard\Frest\Type\TypeStoreRequest;
use Modules\News\Http\Requests\Dashboard\Frest\Type\TypeUpdateRequest;


class TypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('type.access');
        $types = Type::
        when(Request()->q != null,function ($query){
            return $query->where('title','LIKE','%'.Request()->q."%");
        })
            ->latest()->paginate(15);

        return view('news::Dashboard.Frest.type.index',compact('types'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('type.create');
        return view('news::Dashboard.Frest.type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TypeStoreRequest $request)
    {

        $this->authorize('type.create');
        Type::create([
            'title' => $request->title,
            'state' => $request->state,
            'desc' => $request->desc,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.type.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Type $type)
    {
        $this->authorize('type.edit');
        return view('news::Dashboard.Frest.type.edit',compact('type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(TypeUpdateRequest $request, $id)
    {

        $this->authorize('type.edit');
        $type = Type::find($id);



        $type->title = $request->title;
        $type->state = $request->state;
        $type->desc = $request->desc;

        $type->save();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.type.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('type.delete');
        $type = Type::find($id);

        $type->delete();


        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.type.index');
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('type.delete');
            Type::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('type.edit');
            Type::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('type.edit');
            Type::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
