<?php

namespace Modules\Field\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Field\app\Models\Field;
use Modules\Field\app\Http\Requests\Template\Admin\Frest\Field\FieldStoreRequest;
use Modules\Field\app\Http\Requests\Template\Admin\Frest\Field\FieldUpdateRequest;

class FieldController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('menu.access');
        $fields = Field::where('group_id',Request()->group_id)->latest()->paginate(15);

        return view('field::Dashboard.Frest.field.index',compact('fields'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('menu.create');

        return view('field::Dashboard.Frest.field.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(FieldStoreRequest $request)
    {

        $this->authorize('menu.create');


        Field::create([
            'title' => $request->title,
            'name' => $request->name,
            'label' => $request->label,
            'type' => $request->type,
            'required' => $request->required,
            'status' => $request->status,
            'public' => $request->public,
            'show_filter' => $request->show_filter,
            'order' => 0,
            'group_id' => $request->group_id,
        ]);


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.field.index',['group_id' => $request->group_id]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Field $field)
    {
        $this->authorize('menu.edit');

        return view('field::Dashboard.Frest.field.edit',compact('field' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(FieldUpdateRequest $request, Field $field)
    {
        $this->authorize('menu.edit');


         $field->title =  $request->title;
         $field->name =  $request->name;
         $field->label =  $request->label;
         $field->type =  $request->type;
         $field->required =  $request->required;
         $field->status =  $request->status;
         $field->public =  $request->public;
         $field->show_filter =  $request->show_filter;
         $field->order =  0;
         $field->update();



        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.field.index',['group_id' => $field->group_id]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Field $menu)
    {
        $this->authorize('menu.delete');
        $menu->delete();
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('type.delete');
            Field::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('type.edit');
            Field::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('type.edit');
            Field::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
