<?php

namespace Modules\Field\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Modules\Category\app\Models\Category;
use Modules\Field\app\Models\FieldGroup;
use Modules\Field\app\Http\Requests\Template\Admin\Frest\FieldGroup\FieldGroupStoreRequest;
use Modules\Field\app\Http\Requests\Template\Admin\Frest\FieldGroup\FieldGroupUpdateRequest;

class FieldGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('menu.access');
        $groups = FieldGroup::latest()->paginate(15);

        return view('field::Dashboard.Frest.field-group.index',compact('groups'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('menu.create');
        $user = Auth::guard('admin')->user();
        $categories = Category::whereState(1)->whereType('news')->whereState(1)->whereHas('roles', function ($query)  use ($user) {
            $query->whereIn('id',$user->roles->pluck('role_id'));
        })->whereNull('parent_id')->get();
        $groups = FieldGroup::latest()->get();

        return view('field::Dashboard.Frest.field-group.create',compact( 'groups','categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(FieldGroupStoreRequest $request)
    {

        $this->authorize('menu.create');


        FieldGroup::create([
            'title' => $request->title,
            'name'  => $request->name,
            'order' => 0,
            'type'  => $request->type,
        ]);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.field-group.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit( $group)
    {
        $this->authorize('menu.edit');
        $group = FieldGroup::find($group);
        $user = Auth::guard('admin')->user();
        $categories = Category::whereState(1)->whereType('news')->whereState(1)->whereHas('roles', function ($query)  use ($user) {
            $query->whereIn('id',$user->roles->pluck('role_id'));
        })->whereNull('parent_id')->get();


        return view('field::Dashboard.Frest.field-group.edit',compact('group','categories' ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(FieldGroupUpdateRequest $request, FieldGroup $fieldGroup)
    {
        $this->authorize('menu.edit');


        $fieldGroup->title = $request->title;
        $fieldGroup->name = $request->name;
        $fieldGroup->order = 0;
        $fieldGroup->type = $request->type;
        $fieldGroup->update();


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.field-group.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(FieldGroup $group)
    {
        $this->authorize('menu.delete');
        $menu->delete();
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('type.delete');
            FieldGroup::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('type.edit');
            FieldGroup::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('type.edit');
            FieldGroup::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
