<?php

namespace Modules\Field\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Category\app\Models\Category;

class FieldGroup extends Model
{

    use SoftDeletes;

    protected $fillable = [
        'title',
        'name',
        'order',
        'state',
        'type'
    ];




    public function fields(){
        return $this->hasMany(Field::class,'group_id');
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'field_group_category','category_id');
    }
}
