<?php

namespace Modules\Field\app\Models;

use Dotenv\Parser\Value;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FieldModel extends Model
{

    protected $table = 'field_model';

    protected $fillable = [
        'model_type','model_id','field_id','value_id'
    ];



    public function fieldModel()
    {
        return $this->morphTo();
    }


    public function value(){
        return $this->belongsTo(FieldValue::class,'value_id');
    }

    public function field(){
        return $this->belongsTo(Field::class,'field_id');
    }



}
