<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fields', function (Blueprint $table) {
            $table->id();

            $table->string('title',255);
            $table->string('label',255)->nullable();
            $table->string('name')->nullable()->unique();
            $table->enum('type',['text','string','file','select','multiselect'])->default('string');
            $table->boolean('required')->default(0);
            $table->boolean('status')->default(0);
            $table->boolean('public')->default(0);
            $table->boolean('show_filter')->default(0);
            $table->tinyInteger('order')->default(0);

            $table->unsignedBigInteger('group_id');
            $table->foreign('group_id')->references('id')->on('field_groups')->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fields');
    }
};
