<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('field_model', function (Blueprint $table) {
            $table->id();

            $table->string('model_type');
            $table->integer('model_id');

            $table->unsignedBigInteger('field_id');
            $table->unsignedBigInteger('value_id')->nullable();

            $table->foreign('value_id')->references('id')->on('field_values')->onDelete('cascade');
            $table->foreign('field_id')->references('id')->on('fields')->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('field_model');
    }
};
