@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

@section('style')

@endsection

@section('script')

@endsection

@section('content')


    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                        <form action="{{route('admin.field.store',['group_id' => Request()->group_id])}}" method="post">
                            {{ csrf_field() }}

                            <div class="row g-3">

                                <div class="col-md-8">

                                    <div class="row">

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{old('title')}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="label">برچسب</label>
                                            <input type="text" id="label"  name="label" class="form-control" placeholder="برچسب" value="{{old('label')}}">
                                            @if($errors->has('label'))
                                                <div data-field="label" class="text-danger">{{ $errors->first('label') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="name">کلید</label>
                                            <input type="text" id="name"  name="name" class="form-control" placeholder="کلید" value="{{old('name')}}">
                                            @if($errors->has('name'))
                                                <div data-field="name" class="text-danger">{{ $errors->first('name') }}</div>
                                            @endif
                                        </div>



                                    </div>

                                </div>

                                <div class="col-md-4">

                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="state">نوع</label>
                                        <div class="position-relative">
                                            <select id="type" name="type" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="text" {{'text' == old('type') ? 'selected' : ''}}>متن بلند</option>
                                                <option value="string" {{'string' == old('type') ? 'selected' : ''}}>متن</option>
                                                <option value="file" {{'file' == old('type') ? 'selected' : ''}}>فایل</option>
                                                <option value="select" {{'select' == old('type') ? 'selected' : ''}}>تک انتخابی</option>
                                                <option value="multiselect" {{'multiselect' == old('type') ? 'selected' : ''}}>چند انتخابی</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="status">وضعیت</label>
                                        <div class="position-relative">
                                            <select id="status" name="status" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{1 == old('status') ? 'selected' : ''}}>فعال</option>
                                                <option value="0" {{0 == old('status') ? 'selected' : ''}}>غیر فعال</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="show_filter">نمایش در فیلتر</label>
                                        <div class="position-relative">
                                            <select id="show_filter" name="show_filter" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{1 == old('show_filter') ? 'selected' : ''}}>بله</option>
                                                <option value="0" {{0 == old('show_filter') ? 'selected' : ''}}>خیر</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="show_filter">عمومی</label>
                                        <div class="position-relative">
                                            <select id="public" name="public" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{1 == old('public') ? 'selected' : ''}}>بله</option>
                                                <option value="0" {{0 == old('public') ? 'selected' : ''}}>خیر</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-md-12">
                                        <span>*</span>
                                        <label class="form-label" for="show_filter">اجباری</label>
                                        <div class="position-relative">
                                            <select id="required" name="required" class="form-select" >
                                                <option value="" >انتخاب</option>
                                                <option value="1" {{1 == old('required') ? 'selected' : ''}}>بله</option>
                                                <option value="0" {{0 == old('required') ? 'selected' : ''}}>خیر</option>
                                            </select>
                                        </div>
                                    </div>









                                </div>



                            </div>
                            <div class="pt-4">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.field.index',['group_id',Request()->group_id]) }}" type="reset" class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>




@endsection
