<?php

namespace Modules\File\app\Http\Controllers\Dashboard\Frest;



use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\File\app\Http\Requests\Dashboard\Frest\Gallery\StoreGalleryRequest;
use Modules\File\app\Http\Requests\Dashboard\Frest\Gallery\UpdateGalleryRequest;


class FileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        $galleries = \Modules\File\app\Models\File::
            where('type','parts')
            ->where('file_id',Request()->file_id)
            ->where('file_type',Request()->file_type)
            ->paginate();

        $file_id = Request()->file_id;
        $file_type = Request()->file_type;

        return view('file::Dashboard.Frest.gallery.index',compact('galleries','file_id','file_type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreGalleryRequest $request)
    {


        if($request->file != null) {
            $file = File::uploadByFileManager($request->file);
        }

        \Modules\File\app\Models\File::create([
            'file' => $file,
            'title' => $request->title,
            'state' => $request->state,
            'desc' => $request->desc,
            'type' => 'parts',
            'file_id' =>  Request()->file_id,
            'file_type' =>  Request()->file_type
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateGalleryRequest $request,$id)
    {

        $gallery = \Modules\File\app\Models\File::find($id);

        $file = $gallery->file;
        if($request->file != null) {
            $file = File::uploadByFileManager($request->file);
        }

        $gallery->update([
            'file' => $file,
            'title' => $request->title,
            'state' => $request->state,
            'desc' => $request->desc,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $gallery = \Modules\File\app\Models\File::find($id);
        $gallery->delete();
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('album.delete');
            \Modules\File\app\Models\File::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('album.edit');
            \Modules\File\app\Models\File::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('album.edit');
            \Modules\File\app\Models\File::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }


        Cache::forget('sites-' . config('app.template_site'));
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}

