<?php

namespace Modules\File\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class File extends Model
{
    use SoftDeletes;
    protected $table = "files";
    protected $fillable = ['file',
        'title','state',
        'desc','type','file_id','file_type'];


    public function filable()
    {
        return $this->morphTo();
    }

    public function getFileAttribute($value){
        return $value;
    }
}
