@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
   فایل ها
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/modal-add-new-cc.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-add-new-address.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-edit-user.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-enable-otp.js') }}"></script>
@endsection

@section('content')


    <div class="modal fade" id="create-gallery" data-bs-backdrop="static" tabindex="-1">
        <div class="modal-dialog">
            <form class="modal-content" action="{{route('admin.file.store')}}" method="post">
                @csrf
                <input type="text" style="display:none" name="file_id" value="{{$file_id}}">
                <input type="text" style="display:none" name="file_type" value="{{$file_type}}">
                <div class="modal-header">
                    <h5 class="modal-title" id="backDropModalTitle">ایجاد فایل</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group {{ $errors->has('title') ? 'has-errors' : '' }}">
                                <label for="field-1" class="control-label">عنوان</label>
                                <input type="text" name="title" required class="form-control" id="field-1" placeholder="عنوان" value="{{old('title')}}">
                                @if($errors->has('title'))
                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6 {{ $errors->has('state') ? 'has-errors' : '' }}">
                            <label for="field-2" class="control-label">وضعیت</label>
                            <select  name="state" required class="form-control" id="field-2"  >
                                <option value="1">فعال</option>
                                <option value="0">غیر فعال</option>
                            </select>
                            @if($errors->has('state'))
                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('state') }}</strong>
                                    </span>
                            @endif
                        </div>

                        <div class="col-md-12">
                            <label class="form-label" for="title">فایل</label>
                            <div class="input-group">
                                <input type="text" id="image-2" class="form-control" name="file"
                                       aria-label="Image" aria-describedby="button-image-2">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" id="button-image-2">آپلود</button>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-12">
                            <div class="form-group {{ $errors->has('desc') ? 'has-errors' : '' }}">
                                <label for="field-1" class="control-label">توضیحات</label>
                                <textarea  name="desc" required class="form-control" id="field-1" >{{old('desc')}}</textarea>
                                @if($errors->has('desc'))
                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('desc') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>



                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                    <button type="submit" class="btn btn-primary">ذخیره</button>
                </div>

            </form>
        </div>
    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.files') }}" method="get">
            <p class="demo-inline-spacing">
                <button type="button"  data-bs-toggle="modal" data-bs-target="#create-gallery" class="btn btn-primary me-1">جدید</button>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>

            <h5 class="card-header">فایل ها</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($galleries as $file)


                            <tr >

                                <!-- Modal -->

                                <td>


                                    <div class="modal fade" id="update-gallery-{{$file->id}}" data-bs-backdrop="static" tabindex="-1">
                                        <div class="modal-dialog">
                                            <form class="modal-content" action="{{route('admin.file.update',$file->id)}}" method="post">
                                                @csrf
                                                @method('PATCH')
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="backDropModalTitle">ویرایش فایل</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">

                                                    <div class="row">

                                                        <div class="col-md-8">
                                                            <div class="form-group {{ $errors->has('title') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">عنوان</label>
                                                                <input type="text" name="title" required class="form-control" id="field-1" placeholder="عنوان" value="{{old('title',$file->title)}}">
                                                                @if($errors->has('title'))
                                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>


                                                        <div class="col-md-4 {{ $errors->has('state') ? 'has-errors' : '' }}">
                                                            <label for="field-2" class="control-label">وضعیت</label>
                                                            <select  name="state" required class="form-control" id="field-2"  >
                                                                <option value="1" {{$file->state == 1 ? 'selected' : ''}}>فعال</option>
                                                                <option value="0" {{$file->state == 0 ? 'selected' : ''}}>غیر فعال</option>
                                                            </select>
                                                            @if($errors->has('state'))
                                                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('state') }}</strong>
                                    </span>
                                                            @endif
                                                        </div>


                                                        <div class="col-md-12">
                                                            <label class="form-label" for="title">فایل</label>
                                                            <div class="input-group">
                                                                <input type="text" id="image-{{$file->id}}" class="form-control" name="file"
                                                                       aria-label="Image" aria-describedby="button-image" value="{{$file->file}}">
                                                                <div class="input-group-append">
                                                                    <button class="btn btn-outline-secondary" type="button" id="button-image-{{$file->id}}">آپلود</button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-12">
                                                            <div class="form-group {{ $errors->has('desc') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">توضیحات</label>
                                                                <textarea  name="desc" required class="form-control" id="field-1" >{{old('desc',$file->desc)}}</textarea>
                                                                @if($errors->has('desc'))
                                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('desc') }}</strong>
                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <script>

                                                            document.addEventListener("DOMContentLoaded", function() {

                                                                document.getElementById('button-image-{{$file->id}}').addEventListener('click', (event) => {
                                                                    event.preventDefault();
                                                                    inputId = 'image-{{$file->id}}';
                                                                    window.open('/file-manager/fm-button', 'fm', 'width=1400,height=800');
                                                                });

                                                            });

                                                        </script>




                                                    </div>

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                                                    <button type="submit" class="btn btn-primary">ذخیره</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$file->id}}" type="checkbox">
                                        <label for="bulk-ids">{{$file->id}}</label>
                                    </div>
                                </td>
                                <td> {{ $file->title }}</td>

                                @if($file->state == 1)
                                    <td><span class="badge bg-label-success me-1">فعال</span></td>
                                @endif
                                @if($file->state == 0)
                                    <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                                @endif


                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#update-gallery-{{$file->id}}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$file->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$file->id}}" action="{{ route('admin.file.destroy', $file->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>


                            </tr>


                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $galleries->render() }}
                </div>

            </div>





    </div>
@endsection
