<?php

namespace Modules\Invoice\app\Http\Controllers\Dashboard\Frest;



use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Session;
use Modules\Invoice\app\Models\Invoice;
use Modules\Page\app\Models\Page;
use Modules\Page\app\Http\Requests\Dashboard\Frest\Page\PageUpdateRequest;


class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $this->authorize('invoice.access');

            $invoices = Invoice::latest()->paginate(15);

        return view('invoice::Dashboard.Frest.invoice.index' , compact('invoices'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
       //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Invoice $invoice)
    {

        $this->authorize('invoice.access');

        return view('invoice::Dashboard.Frest.invoice.edit',compact('invoice'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PageUpdateRequest $request,Page $invoice)
    {
        $this->authorize('invoice.edit');





        $invoice->title = $request->title;
        $invoice->body = $request->body;
        $invoice->lang = $request->lang;
        $invoice->meta_tag = $request->meta_tag;
        $invoice->meta_desc = $request->meta_desc;
        $invoice->state = $request->state;
        $invoice->save();



        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.invoice.index');

    }




}
