<?php

namespace Modules\Invoice\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Invoice\Database\factories\CartFactory;

class Cart extends Model
{
    use HasFactory,SoftDeletes;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'cartable_id',
        'cartable_type',
        'count',
        'price',
        'discount',
        'total',
    ];

    protected static function newFactory(): CartFactory
    {
        //return CartFactory::new();
    }

    public function cartable(): MorphTo
    {
        return $this->morphTo();
    }
}
