<?php

namespace Modules\Invoice\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Invoice\Database\factories\InvoiceFactory;

class Invoice extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'customer_id','name','lang',
        'note','address','mobile','status','payment_drive','token','ref_id','sub_total','discount','total'
    ];

    public function invoiceItems (){
        return $this->hasMany(InvoiceItem::class,'invoice_id');
    }
}
