<?php

namespace Modules\Invoice\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Invoice\Database\factories\InvoiceItemFactory;

class InvoiceItem extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'invoice_id',
        'item_id',
        'item_type',
        'sub_total',
        'count',
        'discount',
        'total'
    ];


    public static function boot()
    {
        parent::boot();

        static::created(function($item)
        {
            //todo need to isolation this function
            $total = self::where('invoice_id',$item->invoice_id)->sum('total');
            $sub_total = self::where('invoice_id',$item->invoice_id)->sum('sub_total');
            $discount = self::where('invoice_id',$item->invoice_id)->sum('discount');

            $invoice = Invoice::find($item->invoice_id);
            $invoice->total = $total;
            $invoice->discount = $discount;
            $invoice->sub_total = $sub_total;
            $invoice->update();
        });

        static::updated(function($item)
        {
            //todo need to isolation this function
            $total = self::where('invoice_id',$item->invoice_id)->sum('total');
            $sub_total = self::where('invoice_id',$item->invoice_id)->sum('sub_total');
            $discount = self::where('invoice_id',$item->invoice_id)->sum('discount');

            $invoice = Invoice::find($item->invoice_id);
            $invoice->total = $total;
            $invoice->discount = $discount;
            $invoice->sub_total = $sub_total;
            $invoice->update();
        });

        static::deleted(function($item)
        {
            //todo need to isolation this function
            $total = self::where('invoice_id',$item->invoice_id)->sum('total');
            $sub_total = self::where('invoice_id',$item->invoice_id)->sum('sub_total');
            $discount = self::where('invoice_id',$item->invoice_id)->sum('discount');

            $invoice = Invoice::find($item->invoice_id);
            $invoice->total = $total;
            $invoice->discount = $discount;
            $invoice->sub_total = $sub_total;
            $invoice->update();
        });
    }

    public function invoice () {
        return $this->belongsTo(Invoice::class,'invoice_id');
    }


    public function item() {
        return $this->morphTo(InvoiceItem::class,'item_type','item_id');
    }
}
