<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('customer_id');
            $table->string('name')->nullable();
            $table->string('address')->nullable();
            $table->mediumText('note')->nullable();
            $table->string('mobile')->nullable();
            $table->string('status')->nullable();
            $table->string('payment_drive')->default('zarinpal');
            $table->string('token')->nullable();
            $table->string('ref_id')->nullable();
            $table->decimal('sub_total',20, 3)->default(0);
            $table->decimal('discount')->default(0);
            $table->decimal('total',20, 3)->default(0);
            $table->string('lang')->default('fa');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
