
@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/css/pages/app-invoice.css')}}" />

        @endsection

@section('script')


    <script src="{{asset('modules/core/js/app-invoice-edit.js')}}"></script>
@endsection


@section('content')


    <section class="invoice-view-wrapper">
        <div class="row">
            <!-- invoice view page -->
            <div class="col-xl-9 col-md-8 col-12">
                <div class="card invoice-print-area">
                    <div class="card-content">
                        <div class="card-body pb-0 mx-25">
                            <!-- header section -->
                            <div class="row line-height-2 mt-n50">
                                <div class="col-xl-4 col-md-12 mb-50 mb-xl-0">
                                    <span class="invoice-number mr-50">صورتحساب</span>
                                    <span>{{$invoice->id}}</span>
                                </div>
                                <div class="col-xl-8 col-md-12">
                                    <div class="d-flex align-items-center justify-content-xl-end flex-wrap">
                                        <div class="mr-3">
                                            <small class="text-muted">تاریخ :</small>
                                            <span>{{Verta($invoice->created_at)->format('Y/m/d ')}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <!-- invoice address and contact -->
                            <div class="row invoice-info">
                                <div class="col-6 mt-1">
                                    <div class="mb-75">
                                        <span>نام مشتری : {{$invoice->name}}</span>
                                    </div>
                                    <div class="mb-75">
                                        <span class="ltr-text">شماره همراه :{{$invoice->mobile}}</span>
                                    </div>
                                </div>

                            </div>
                            <hr>
                        </div>
                        <!-- product details table-->
                        <div class="invoice-product-details table-responsive mx-md-25">
                            <table class="table table-borderless mb-0">
                                <thead>
                                <tr class="border-0">
                                    <th scope="col">آیتم</th>
                                    <th scope="col">هزینه</th>
                                    <th scope="col">تخفیف</th>
                                    <th scope="col">تعداد</th>
                                    <th scope="col" class="text-right">قیمت</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($invoice->invoiceItems as $invoiceItem)
                                <tr>
                                    <td>{{$invoiceItem->item->title}}</td>
                                    <td>{{$invoiceItem->sub_total}} تومان</td>
                                    <td>{{$invoiceItem->discount}} تومان</td>
                                    <td>{{$invoiceItem->count}} تومان</td>
                                    <td>{{$invoiceItem->total}} تومان</td>
                                </tr>
                                @endforeach

                                </tbody>
                            </table>
                        </div>

                        <!-- invoice subtotal -->
                        <div class="card-body pt-0 mx-25">
                            <hr>
                            <div class="row">
                                <div class="col-4 col-sm-6 mt-75">
                                    <p>{{$invoice->note}}.</p>
                                </div>
                                <div class="col-8 col-sm-6 d-flex justify-content-end mt-75">
                                    <div class="invoice-subtotal">
                                        <div class="invoice-calc d-flex justify-content-between">
                                            <span class="invoice-title">جمع جزء</span>
                                            <span class="invoice-value">{{number_format($invoice->sub_total)}} تومان</span>
                                        </div>
                                        <div class="invoice-calc d-flex justify-content-between">
                                            <span class="invoice-title">تخفیف</span>
                                            <span class="invoice-value">- {{number_format($invoice->discount)}} تومان</span>
                                        </div>
                                        <div class="invoice-calc d-flex justify-content-between">
                                            <span class="invoice-title">مبلغ پرداختی</span>
                                            <span class="invoice-value"> {{number_format($invoice->total)}} تومان</span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- invoice action  -->
            <div class="col-xl-3 col-md-4 col-12">
                <div class="card invoice-action-wrapper shadow-none border">
                    <div class="card-body">
{{--                        <form action="{{route('admin.invoice.update',$invoice->id)}}">--}}
{{--                            @method('PATCH')--}}
{{--                            --}}
{{--                            <div class="col-md-8">--}}
{{--                                <span>*</span>--}}
{{--                                <label class="form-label" for="title">عنوان</label>--}}
{{--                                <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{old('title')}}">--}}
{{--                                @if($errors->has('title'))--}}
{{--                                    <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>--}}
{{--                                @endif--}}
{{--                            </div>--}}
{{--                            --}}
{{--                            --}}
{{--                        </form>--}}
                    </div>
                </div>
            </div>
        </div>
    </section>


@endsection
