@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')

        @endsection

    @section('script')

    @endsection

@section('content')


    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" data-bs-toggle="collapse" data-bs-target=".multi-collapse" aria-expanded="false" aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.invoice.index')}}" method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q"  name="q" class="form-control" placeholder="جستجو" value="{{old('q')}}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button" class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">

        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard('فاکتور ها')}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>اطلاعات مشتری</th>
                    <th>وضعیت</th>
                    <th>تاریخ</th>
                    <th>مبلغ سفارش</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach($invoices as $item)
                    <tr >
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)" name="ids[]"value="{{$item->id}}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                             <b>{{$item->name}} - {{$item->mobile}}</b>
                        </td>

                        @if($item->status == 'pending')
                            <td><span class="badge bg-label-warning me-1">معلق</span></td>
                        @endif
                        @if($item->status == 'success')
                            <td><span class="badge bg-label-success me-1">موفقیت آمیز</span></td>
                        @endif
                        @if($item->status == 'unsuccess')
                            <td><span class="badge bg-label-danger me-1">ناموفق</span></td>
                        @endif



                        <td>
                            @if($item->created_at != null)
                                {{ Verta($item->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            @if($item->total != null)
                                {{ $item->total }}
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.invoice.edit' ,$item->id) }}"><i class="bx bx-edit-alt me-1"></i>مشاهده</a>
                                </div>
                            </div>
                        </td>
                    </tr>

                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{ $invoices->render() }}
            </div>
        </div>





    </div>



@endsection
