<?php

namespace Modules\Maf\app\Http\Controllers\App\V1\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Modules\Admin\app\Models\Admin;
use Modules\Note\app\Models\Note;
use Modules\Otp\app\Models\Otp;
use Modules\User\app\Models\User;

class LoginController extends Controller
{

    public function login(Request $request)
    {
        $user = Admin::where('mobile', $request->mobile)->first();

        if ($user){

                if (! $user || ! Hash::check(\request('password'), $user->password)) {
                    return Response()->error('اطلاعات نادرست هست',[],404);
                }

                $token = $user->createToken('MyApp')->plainTextToken;

                $status = 'redirect_home';
                return Response()->success([
                    "status"=> $status,
                    "user"=>$user,
                    'token' => $token,
                ],'کاربرگرامی خوش آمدید', 200);

            } else {
                return Response()->error('اطلاعات نادرست دوباره سعی کنید',[], 404);
            }

    }
    public function checkUser()
    {
        if(Auth::guard('api:admin')->user()){

            $user = Auth::guard('api:admin')->user();

            return Response()->success([
                'user' => $user,
            ],'موفقیت آمیز');

        }else {
            return Response()->error([
                'user' => [],
            ],'کاربر لاگین نیست', 401);
        }

    }

    public function logout()
    {
        if(Auth::guard('api:admin')->user()){

            Request()->user()->currentAccessToken()->delete();


            return Response()->success([],'موفقیت آمیز');

        }else {
            return Response()->error([
                'user' => [],
            ],'کاربر لاگین نیست', 401);
        }

    }
}
