<?php

namespace Modules\Maf\app\Http\Controllers\V1\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Modules\Note\app\Models\Note;
use Modules\Otp\app\Models\Otp;
use Modules\User\app\Models\User;

class LoginController extends Controller
{



    //Step One
    public function login(Request $request)
    {


        $user = User::firstOrCreate(['mobile'=> $request->mobile],['mobile'=> $request->mobile]);


        if($user){
            if($user && $user->password == null){

                $otpCode = rand(1000, 9999);

                OTP::updateOrCreate(
                    ['mobile' => $request->mobile],
                    ['code' => $otpCode]
                );

                $status = 'redirect_verification';

                return Response()->success([
                    "status"=> $status,
                    "mobile" => $user->mobile,
                    "otp" => $otpCode,
                ], "کد فعالسازی به تلفن همراه ارسال شد");

            } else {

                $status = 'redirect_get_password';

                return Response()->success([
                    "status"=> $status,
                    "mobile" => $user->mobile,
                ], "با موفقیت انجام شد");

            }

        }

    }

    //Step Two
    public function verifyCode(Request $request)
    {


        $user = User::where('mobile', $request->mobile)->first();


        if($user){
            $otp = OTP::where('mobile', $user->mobile)->where('code', $request->verification_code)->first();


            if ($otp) {

                $token = $user->createToken('MyApp')->plainTextToken;

                if($user->password == null){
                    $status = 'redirect_set_password';

                    return Response()->success([
                        "status"=>$status,
                        "user"=>$user,
                        "token"=>$token,
                        "message"=>"لطفا یک رمز عبور برای خود انتخاب کنید",
                    ], 200);

                } else {

                    $status = 'redirect_home';
                    return Response()->success([
                        "status"=>$status,
                        "user" => $user,
                        "token"=>$token,
                        "message"=>"کاربر گرامی خیلی خوش آمدید",
                    ], 200);
                }

            }
            else {
                return Response()->error([], "اطلاعات نادرست",404);
            }
        } else {
            return  Response()->error('موبایل پیدا نشد',[],404);
        }

        }

    public function loginByPassword(Request $request)
    {
        $user = User::where('mobile', $request->mobile)->first();

        if ($user){

                if (! $user || ! Hash::check(\request('password'), $user->password)) {
                    return Response()->error('اطلاعات نادرست هست',[],404);
                }

                $token = $user->createToken('MyApp')->plainTextToken;

                $status = 'redirect_home';
                return Response()->success([
                    "status"=> $status,
                    "user"=>$user,
                    'token' => $token,
                ],'کاربرگرامی خوش آمدید', 200);

            } else {


                return Response()->error('اطلاعات نادرست دوباره سعی کنید',[], 404);
            }

    }

    public function setPassword(Request $request)
    {

        if (Auth::guard('api:user')->user())
        {
            $user = Auth::guard('api:user')->user();
            $user->password = bcrypt($request->password);
            $user->update();

            $status = 'redirect_home';
            return Response()->success([
                "status"=> $status,
                'user' => $user
            ], 200);
        }

    }


    public function checkUser()
    {
        if(Auth::guard('api:user')->user()){

            $user = Auth::guard('api:user')->user();

            return Response()->success([
                'user' => $user,
            ],'موفقیت آمیز');

        }else {
            return Response()->error([
                'user' => [],
            ],'کاربر لاگین نیست', 401);
        }

    }

    public function logout()
    {
        if(Auth::guard('api:user')->user()){

            Request()->user()->currentAccessToken()->delete();


            return Response()->success([],'موفقیت آمیز');

        }else {
            return Response()->error([
                'user' => [],
            ],'کاربر لاگین نیست', 401);
        }

    }
}
