<?php

namespace Modules\Maf\app\Http\Controllers\V1\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Modules\Note\app\Models\Note;
use Modules\Otp\app\Models\Otp;
use Modules\User\app\Models\User;

class ResetPasswordController extends Controller
{
    public function forget_password(Request $request)
    {
        $user = User::where('mobile', $request->mobile)->first();

        if ($user)
        {
            $otpCode = rand(1000, 9999);

            OTP::updateOrCreate(
                ['mobile' => $request->mobile],
                ['code' => $otpCode]
            );

            // sendVerificationCode($request->phone, $otpCode);

            return Response()->success([
                'otpCode'=>$otpCode
            ],'verification-code-sent', 200);
        }
        else
        {
            return Response()->error([

            ],'phone-number-not-found');
        }
    }

    public function verify_reset_code(Request $request)
    {
        $otp = OTP::where('mobile', $request->mobile)
            ->where('code', $request->verification_code)
            ->first();

        if ($otp)
        {
            return Response()->success([
            ],'get-password', 200);
        }
        else
        {
            return Response()->error([

            ],'invalid-verification-code', 400);
        }
    }

    public function reset_password(Request $request)
    {
        $user = User::where('mobile', $request->mobile)->first();
        $user_note = Note::where('user_id', $user->id)->where('read', 0)->get();

        if ($user)
        {
            $token = $user->createToken('MyApp')->plainTextToken;
            $user->password = Hash::make($request->password);
            $user->save();

            return Response()->success([
                'token' => $token,
                'user_note' => $user_note
            ],'password-edited-successfully', 200);
        }
        else
        {
            return Response()->error([

            ],'phone-number-not-found', 400);
        }
    }
}
