<?php

namespace Modules\Maf\app\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Comment\app\Models\Comment;
use Modules\News\app\Models\News;
use Modules\User\app\Models\User;

class CommentController extends Controller
{
    public function add_comment(Request $request)
    {
        $news_exist = News::where('id', $request->input('news_id'))->where('state', 1)->first();

        if ($news_exist)
        {
            $news = News::find($request->input('news_id'));
            $name = $request->input('name');
            $email = $request->input('email');
            $ip = $request->ip();
            $user_agent = $request->userAgent();
            $body = $request->input('body');

            $news->comments()->create([
                'name' => $name,
                'email' => $email,
                'ip' => $ip,
                'user-agent' => $user_agent,
                'body' => $body,
            ]);

            return Response()->success([
                "message"=>"نظر شما با موفقیت ثبت شد و پس از بررسی توسط ادمین فعال میشود",
            ], 200);
        }
        else
        {
            return Response()->error('خبری با این شناسه موجود نیست',[], 404);
        }
    }
}
