<?php

namespace Modules\Maf\app\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Competition\app\Models\Competition;
use Modules\Competition\app\Models\CompetitionCategory;
use Modules\User\app\Models\User;
use Morilog\Jalali\Jalalian;
use Modules\Core\app\Http\Controllers\Helpers\Str;

class CompetitionController extends Controller
{
    public function category()
    {
        $category = CompetitionCategory::where('state', '1')->get();
        return Response()->success([
            'category' => $category,
        ],'', 200);
    }
    public function prices()
    {
        $price = [
            [
                "title"=>"رایگان",
                "name"=>"free"
            ],
            [
                "title"=>"غیر رایگان",
                "name"=>"none_free"
            ],
            [
                "title"=>"حق عضویت",
                "name"=>"membership"
            ]
        ];
        return Response()->success([
            'price' => $price,
        ],'', 200);
    }
}
