<?php

namespace Modules\Maf\app\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Carbon\Carbon;
use Modules\Category\app\Models\Category;
use Modules\Comment\app\Models\Comment;
use Modules\Competition\app\Models\Competition;
use Modules\Maf\app\Http\Controllers\Str;
use Modules\Menu\app\Models\Menu;
use Modules\News\app\Models\News;
use Modules\Service\app\Models\ServiceModel;
use Morilog\Jalali\Jalalian;

class HomeController extends Controller
{
    public function index()
    {
        $ads_slider = ServiceModel::active("ads_slider","ads","desc")->limit(4)->get();
        $ads_new = ServiceModel::active("ads_new","ads","desc")->limit(4)->get();
        $news = ServiceModel::active("news","news","desc")->limit(4)->get();
        $last_competitions = ServiceModel::active("last_competitions","competitions","desc")->limit(4)->get();
        $ads_down = ServiceModel::active("ads_down","ads","desc")->limit(4)->get();
        $news_down = ServiceModel::active("news_down","news","desc")->limit(4)->get();

        return Response()->success([
            'ads_slider' => $ads_slider,
            'ads_new' => $ads_new,
            'news' => $news,
            'last_competitions' => $last_competitions,
            'news_down' => $news_down,
            'ads_down' => $ads_down,
        ],'Home information');
    }
    public function news($id = null)
    {

        $category = null;
        if($id != null){
            $category = Category::whereState(1)->whereId($id)->first();

            SEOMeta::setTitle($category->title);
            SEOMeta::setDescription($category->meta_desc);
            SEOMeta::addMeta('article:section', $category->title, 'property');

            SEOMeta::setCanonical(config('app.url').$category->route);
            OpenGraph::setDescription($category->meta_desc);
            OpenGraph::setTitle($category->title);
            OpenGraph::setUrl(config('app.url').$category->route);
            OpenGraph::addProperty('type', 'website');
            OpenGraph::addProperty('locale','fa_IR');
            OpenGraph::addProperty('locale:alternate', ['fa_IR']);
            OpenGraph::addImage($category->image);
            OpenGraph::addImage($category->image);
            OpenGraph::addImage(['url' => $category->image, 'size' => 300]);
            OpenGraph::addImage( $category->image, ['height' => 300, 'width' => 300]);
            JsonLd::setTitle($category->title);
            JsonLd::setDescription($category->meta_desc);
            JsonLd::setType('Article');
            JsonLd::addImage($category->image1_url);
        }



        $special = [];

        $result = News::
        when($id != null && $category->key != 'all',function ($query) use ($id){
            $query->whereHas('category',function ($query2) use ($id){
                $query2->whereState(1)->where('id',$id);
            })
                ->orWhereHas('categories',function ($query3) use ($id){
                    $query3->whereState(1)->whereIn('id',[$id]);
                });
        })
            ->when(Request()->service != null, function ($query){
                return $query->whereHas('services',function ($query) {
                    return $query->where('service_id',Request()->service);
                });
            })
            ->when(Request()->tags != null, function ($query){
                return $query->whereHas('tags',function ($query){
                    return $query->where('name',Request()->tags);
                });
            })
            ->when(!is_null(Request()->start_date), function ($query) {
                $start_date = Str::convertToGregorian(str_replace('/','-',Request()->start_date) . ' 00:00:00');
                return $query->whereDate('created_at','>=',$start_date);
            })
            ->when(!is_null(Request()->end_date), function ($query)  {
                $end_date = Str::convertToGregorian(str_replace('/','-',Request()->end_date) . ' 00:00:00');
                return $query->whereDate('created_at','<=',$end_date);
            })
            ->when(isset(Request()->search),function ($query){
                $query ->where('title','LIKE','%'.Request()->search."%")
                    ->orWhere('body','LIKE','%'.Request()->search."%")
                    ->orWhere('lead','LIKE','%'.Request()->search."%");
            })
            ->latest();


        $special = [];
        if(Request()->page == null){
            $query = clone  $result;
            $special = $query->where('special',1)->limit(4)->get();
        }

        $news = $result->paginate(15);

        return Response()->success([
            'news'=>$news,
            'special'=>$special,
            'category'=>$category,
        ],'', 200);
    }
    public function showNews($id)
    {
        $news = News::active()->whereId($id)->first();


        SEOMeta::setTitle($news->title);
        SEOMeta::setDescription($news->lead);
        SEOMeta::addMeta('article:published_time', $news->publish_up, 'property');
        SEOMeta::addMeta('article:section', $news->category->title, 'property');

        SEOMeta::setCanonical(config('app.url').$news->route);
        OpenGraph::setDescription($news->meta_desc);
        OpenGraph::setTitle($news->title);
        OpenGraph::setUrl(config('app.url').$news->route);
        OpenGraph::addProperty('type', 'article');
        OpenGraph::addProperty('locale','fa_IR');
        OpenGraph::addProperty('locale:alternate', ['fa_IR']);
        OpenGraph::addImage($news->image1_url);
        OpenGraph::addImage($news->image1_url);
        OpenGraph::addImage(['url' => $news->image1_url, 'size' => 300]);
        OpenGraph::addImage( $news->image1_url, ['height' => 300, 'width' => 300]);
        JsonLd::setTitle($news->title);
        JsonLd::setDescription($news->meta_desc);
        JsonLd::setType('Article');
        JsonLd::addImage($news->image1_url);

        $news_related = News::active()
            ->where('id','<>',$id)
            ->where('cat_id',$news->cat_id)->latest()->take(8)->get();



        $news->increment('view_count');
        $shareComponent = \Share::page(
            config('app.APP_URL').$news->route,
            $news->title
        )->facebook()
            ->twitter()
            ->linkedin()
            ->telegram()
            ->whatsapp()
            ->reddit()->getRawLinks();

        $news_comment = Comment::where('commentable_id',$id)->where('state',1)->get();

        return Response()->success([
            'news'=>$news,
            'news_related'=>$news_related,
            'shareComponent'=>$shareComponent,
            'news_comment'=>$news_comment,
        ],'', 200);
    }

    public function competition()
    {
        $query = Competition::
        when(!is_null(Request()->cat_id), function ($query) {
            return $query->whereIn('cat_id', (array) Request()->cat_id);
        })
            ->when(!is_null(Request()->price), function ($query) {
                return $query->whereIn('status_pay', (array) Request()->price);
            })
            ->when(!is_null(Request()->city), function ($query) {
                return $query->whereIn('city', (array) Request()->city);
            })
            ->when(!is_null(Request()->start_time), function ($query) {
                $start_time = Jalalian::fromFormat('Y-m-d', Request()->start_time)->toCarbon()->toDateString();
                return $query->whereDate('competition_start_time', '>=', $start_time);
            })
            ->when(!is_null(Request()->end_time), function ($query) {
                $end_time = Jalalian::fromFormat('Y-m-d', Request()->end_time)->toCarbon()->toDateString();
                return $query->whereDate('competition_end_time', '<=', $end_time);
            })
            ->with('category')
            ->select('title', 'status_pay', 'price', 'cat_id', 'image', 'competition_start_time', 'competition_end_time')
            ->get();

        $query->transform(function ($competition) {
            $competition->price = $this->formatPrice($competition->price, $competition->status_pay);
            return $competition;
        });

        return Response()->success([
            'competitions' => $query,
        ],'', 200);
    }
    public function showCompetition($id)
    {
        $item = Competition::whereId($id)->first();




        return Response()->success([
            'item'=>$item
        ],'', 200);
    }

    public function showMenu($name)
    {
        $menu = Menu::where('name',$name)->with(['itemsActive'])->get();


        return Response()->success([
            'item'=> $menu
        ],'', 200);
    }

    private function convertToJalali($value)
    {
        $carbonDate = Carbon::parse($value);
        return Jalalian::fromCarbon($carbonDate)->format('Y/m/d H:i:s');
    }
    private function formatPrice($price, $status_pay)
    {
        if ($status_pay === 'free') {
            return 'رایگان';
        }
        elseif ($status_pay === 'none_free')
        {
            return number_format($price);
        }
        elseif ($status_pay === 'membership')
        {
            return 'حق عضویت';
        }

        return $price; // در غیر این صورت مقدار اصلی را برگردانید
    }

}
